#pragma once
/////////////////////////////////////////////////////////////////////////////
#include "resource.h"
#include "ProfileDll.h"
#include "ConfigDlg.h"
#include "ConfigSPC.h"
#include "afxwin.h"

/////////////////////////////////////////////////////////////////////////////
// CConfigSPCDlg dialog
class CConfigSPCDlg : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigSPCDlg)
private:
	virtual int		GetIconId()		{ return IDI_ICON_SPC; };
public:
	enum { IDD = IDD_DLGCFG_SPC_MAIN };
	CConfigSPCDlg(CConfigSPC* iCfgSPC) : CConfigDlg(CConfigSPCDlg::IDD, theApp.m_hInstance, iCfgSPC){};
	virtual ~CConfigSPCDlg() {};	
protected:
	virtual void DoDataExchange(CDataExchange* pDX)	{ CDialog::DoDataExchange(pDX); };
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL	OnInitDialog()	{ CDialog::OnInitDialog(); return TRUE; };
	virtual char*	GetName()		{ return "Speech";};
	virtual void	UpdateDisplay()	{};
	virtual BOOL	Apply()			{ return TRUE; };
};
/////////////////////////////////////////////////////////////////////////////
// CConfigSPCDlgSettings dialog
class CConfigSPCDlgSettings : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigSPCDlgSettings)
public:
	CConfigSPCDlgSettings(CConfigSPC* iCfgSPC) : CConfigDlg(CConfigSPCDlgSettings::IDD, theApp.m_hInstance, iCfgSPC){};
	virtual ~CConfigSPCDlgSettings() {};
	// Dialog Data
	enum { IDD = IDD_DLGCFG_SPC_SETTINGS };
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
public:
	virtual void	UpdateDisplay();
	virtual char*	GetName()		{ return "Settings";};
	virtual BOOL	Apply();
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL	OnInitDialog();
	CButton mCheckCOLPTA, mCheckCOLPNwk, mCheckCLIPTA, mCheckCLIPNwk, mCheckCSSI, mCheckCSSU;
	CEdit	mEditCLIRSubscription, mEditCLIROnNwk;
};
/////////////////////////////////////////////////////////////////////////////
// CConfigSPCDlgForwarding dialog
class CConfigSPCDlgForwarding : public CConfigDlg
{
	DECLARE_DYNAMIC(CConfigSPCDlgForwarding)
public:
	CConfigSPCDlgForwarding(CConfigSPC* iCfgSPC) : CConfigDlg(CConfigSPCDlgForwarding::IDD, theApp.m_hInstance, iCfgSPC){};
	virtual ~CConfigSPCDlgForwarding() {};
	// Dialog Data
	enum { IDD = IDD_DLGCFG_SPC_FORWARDING };
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
public:
	virtual void	UpdateDisplay();
	virtual char*	GetName()		{ return "Forwarding";};
	virtual BOOL	Apply();
	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL	OnInitDialog();
	int				GetComboKey(const CComboBox* iCombo, int iComboSel);
	CComboBox		mComboReason, mComboClass;
	afx_msg void	OnCbnSelchangeComboReason();
	afx_msg void	OnCbnSelchangeComboClass();
	CEdit	mEditNumber, mEditSubaddr, mEditTime;
	CButton mCheckStatus;
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////